// Copyright (c) Paul Agron
//
// Permission is hereby granted, free of charge, to any person
// obtaining a copy of this software and associated documentation
// files (the "Software"), to deal in the Software without
// restriction, including without limitation the rights to use,
// copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following
// conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
// HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
//
// If you use it, acknowledgement in an About Page or other appropriate place is required.
// For example, "Contains "KTUIKit" by Paul Agron" will do.

#pragma once
#import "SYLogger.h"

//
// Need to align variables so OSAtomic stuff works properly
//

// Since instance variables are implicitly volatile, there's no need to declare them as such.
#define IVAR_VOLATILE

@interface SYConsoleView : NSScrollView
<
#if (MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_6)
NSTableViewDataSource,
#endif // (MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_6)
SYLoggerChannel
>
{
    NSTableView* view;
    NSMutableArray* rows; 
    NSMutableDictionary* defaultTableParameters;
    NSArray *orderedIdentifiers;
    
//#warning Why don't OSAtomicXXX require arguments to be declared volatile in 10.4 (how do they work without being declared volatile) ???    

    IVAR_VOLATILE int32_t   threadShouldContinue __attribute__ ((aligned (4)));
    IVAR_VOLATILE int32_t   threadDidFinish __attribute__ ((aligned (4)));
    IVAR_VOLATILE int32_t   haveDataToReload __attribute__ ((aligned (4)));
    NSTimeInterval          refreshFrequency;
}

-(void)logMessage:(NSString*)msg
         fromFile:(NSString*)fileName 
       lineNumber:(NSUInteger)line
        forObject:(id)obj 
         selector:(SEL)sel 
       threadName:(NSString*)threadName
          atLevel:(NSInteger)level;

-(void) setRefreshFrequency:(NSTimeInterval)frequency;
-(NSTimeInterval) refreshFrequency;

@end
